<?php
session_start();

// Periksa jika pengguna sudah log masuk
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    // --- BAHAGIAN UNTUK PAPARAN FAIL (JIKA SUDAH LOGIN) ---
    echo '<!DOCTYPE html>';
    echo '<html lang="en"><head><title>Senarai Fail</title>';
    echo '<style>body{font-family: sans-serif; padding: 20px;} a{text-decoration: none; color: #007bff;} a:hover{text-decoration: underline;} .logout{float:right;}</style>';
    echo '</head><body>';
    echo '<h1>Senarai Fail Anda</h1>';
    echo '<a href="logout.php" class="logout">Log Keluar</a>';
    echo '<hr><ul>';

    // Imbas semua fail dalam direktori semasa ('.')
    $files = scandir('.');
    foreach ($files as $file) {
        // Jangan senaraikan fail skrip ini, fail semasa (.), dan direktori atas (..)
        if ($file != '.' && $file != '..' && $file != 'index.php' && $file != 'login.php' && $file != 'logout.php') {
            echo '<li><a href="' . htmlspecialchars($file) . '">' . htmlspecialchars($file) . '</a></li>';
        }
    }

    echo '</ul><hr></body></html>';
    exit(); // Hentikan skrip supaya borang login di bawah tidak dipaparkan
}

// --- BAHAGIAN UNTUK BORANG LOGIN (JIKA BELUM LOGIN) ---
// Kod HTML di bawah hanya akan berjalan jika pengguna BELUM log masuk
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sila Log Masuk</title>
    <style>
        body { font-family: sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; background-color: #f0f2f5; margin: 0; }
        .login-container { background-color: #fff; padding: 2rem; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); text-align: center; }
        input[type="password"] { padding: 10px; margin-top: 1rem; border-radius: 4px; border: 1px solid #ccc; width: 200px; }
        button { padding: 10px 20px; margin-top: 1rem; border: none; border-radius: 4px; background-color: #007bff; color: white; cursor: pointer; }
        button:hover { background-color: #0056b3; }
        .error { color: red; margin-top: 10px; }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Akses Terhad</h2>
        <p>Sila masukkan kata laluan untuk teruskan.</p>
        <form action="login.php" method="post">
            <input type="password" name="password" placeholder="Kata Laluan" required>
            <br>
            <button type="submit">Log Masuk</button>
        </form>
        <?php
            // Paparkan mesej ralat jika ada
            if (isset($_GET['error'])) {
                echo '<p class="error">Kata laluan salah!</p>';
            }
        ?>
    </div>
</body>
</html>