import {
	Type,
	House,
	Paperclip,
	Bot,
	Network,
	Globe,
	Share2,
} from 'lucide-react';
import { __ } from '@wordpress/i18n';

// Page contents
import { PAGE_CONTENT as GENERAL_PAGE_CONTENT } from '@AdminGeneral/social/general/general';
import { PAGE_CONTENT as FACEBOOK_PAGE_CONTENT } from '@AdminGeneral/social/facebook/facebook';
import { PAGE_CONTENT as TWITTER_PAGE_CONTENT } from '@AdminGeneral/social/twitter/twitter';
import { PAGE_CONTENT as SITEMAPS_PAGE_CONTENT } from '@AdminGeneral/advanced/sitemaps/sitemaps';
import { PAGE_CONTENT as ARCHIVE_PAGES_PAGE_CONTENT } from '@/apps/admin-general/advanced/archive-pages/archive-pages';
import { PAGE_CONTENT as ADVANCED_PAGE_CONTENT } from '@AdminGeneral/general/home-page/advanced';
import { PAGE_CONTENT as SOCIAL_ACCOUNTS_PAGE_CONTENT } from '@AdminGeneral/social/account/account';
import { PAGE_CONTENT as TITLE_AND_DESCRIPTION_PAGE_CONTENT } from '@AdminGeneral/general/title-and-description/title-and-description';

/**
 * Common navigation configuration that can be used across both dashboard and general settings.
 * @return {Array} Navigation configuration
 */
export const getNavLinks = () => {
	const links = [
		{
			section: __( 'Dashboard', 'surerank' ),
			sectionId: 'dashboard',
			links: [
				{
					label: __( 'Dashboard', 'surerank' ),
					path: '/dashboard',
					icon: House,
				},
				{
					label: __( 'Site SEO Analysis', 'surerank' ),
					path: '/site-seo-analysis',
					icon: House,
				},
			],
		},
		{
			section: __( 'General', 'surerank' ),
			sectionId: 'general',
			links: [
				{
					// This is the root path for the settings page
					path: '/general',
					label: __( 'Meta Templates', 'surerank' ),
					icon: Type,
					pageContent: TITLE_AND_DESCRIPTION_PAGE_CONTENT,
				},
				{
					label: __( 'Social', 'surerank' ),
					path: '/general/social',
					icon: Share2,
					submenu: [
						{
							path: '/general/social',
							label: __( 'Default Social Image', 'surerank' ),
							pageContent: GENERAL_PAGE_CONTENT,
						},
						{
							path: '/general/social/facebook',
							label: __( 'Facebook', 'surerank' ),
							pageContent: FACEBOOK_PAGE_CONTENT,
						},
						{
							path: '/general/social/x',
							label: __( 'X', 'surerank' ),
							pageContent: TWITTER_PAGE_CONTENT,
						},
						{
							path: '/general/social/accounts',
							label: __( 'Other Accounts', 'surerank' ),
							pageContent: SOCIAL_ACCOUNTS_PAGE_CONTENT,
						},
					],
				},
				{
					path: '/general/homepage',
					label: __( 'Home Page', 'surerank' ),
					icon: House,
					submenu: [
						{
							path: '/general/homepage',
							label: __( 'General', 'surerank' ),
						},
						{
							path: '/general/homepage/social',
							label: __( 'Social', 'surerank' ),
						},
						{
							path: '/general/homepage/advanced',
							label: __( 'Advanced', 'surerank' ),
							pageContent: ADVANCED_PAGE_CONTENT,
						},
					],
				},
				{
					path: '/general/archive_pages',
					label: __( 'Archive Pages', 'surerank' ),
					icon: Paperclip,
					pageContent: ARCHIVE_PAGES_PAGE_CONTENT,
				},
			],
		},
		{
			section: __( 'Advanced', 'surerank' ),
			sectionId: 'advanced',
			links: [
				{
					path: '/advanced/robot_instructions',
					label: __( 'Robot Instructions', 'surerank' ),
					icon: Bot,
					submenu: [
						{
							path: '/advanced/robot_instructions/indexing',
							label: __( 'No Index', 'surerank' ),
						},
						{
							path: '/advanced/robot_instructions/following',
							label: __( 'No Follow', 'surerank' ),
						},
						{
							path: '/advanced/robot_instructions/archiving',
							label: __( 'No Archive', 'surerank' ),
						},
					],
				},
				{
					path: '/advanced/sitemaps',
					label: __( 'Sitemaps', 'surerank' ),
					icon: Network,
					pageContent: SITEMAPS_PAGE_CONTENT,
				},
				{
					path: '/advanced/schema',
					label: __( 'Schema', 'surerank' ),
					icon: Globe,
				},
			],
		},
		{
			section: __( 'Search Console', 'surerank' ),
			sectionId: 'search-console',
			links: [
				{
					path: '/search-console',
					label: __( 'Search Console', 'surerank' ),
					icon: Network,
					pageContent: [],
				},
				{
					label: __( 'Content Performance', 'surerank' ),
					path: '/content-performance',
					icon: House,
				},
			],
		},
	];

	return links;
};
